/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.detail;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wile.engineersdecor.libmc.detail.Networking;
import wile.engineersdecor.libmc.detail.SidedProxy;

public class Overlay {
    public static void register() {
        if (SidedProxy.mc() != null) {
            MinecraftForge.EVENT_BUS.register((Object)new TextOverlayGui());
            Networking.OverlayTextMessage.setHandler(TextOverlayGui::show);
        }
    }

    public static void show(Player player, Component message) {
        Networking.OverlayTextMessage.sendToPlayer(player, message, 3000);
    }

    public static void show(Player player, Component message, int delay) {
        Networking.OverlayTextMessage.sendToPlayer(player, message, delay);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    @OnlyIn(value=Dist.CLIENT)
    public static class TextOverlayGui
    extends Screen {
        private static final Component EMPTY_TEXT = new TextComponent("");
        private static double overlay_y_ = 0.75;
        private static int text_color_ = 0xFFAA00;
        private static int border_color_ = -1439485133;
        private static int background_color1_ = -1439485133;
        private static int background_color2_ = -1438366652;
        private final Minecraft mc = SidedProxy.mc();
        private static long deadline_;
        private static Component text_;

        public static void on_config(double overlay_y) {
            TextOverlayGui.on_config(overlay_y, 0xFFAA00, -1439485133, -1439485133, -1438366652);
        }

        public static void on_config(double overlay_y, int text_color, int border_color, int background_color1, int background_color2) {
            overlay_y_ = overlay_y;
            text_color_ = text_color;
            border_color_ = border_color;
            background_color1_ = background_color1;
            background_color2_ = background_color2;
        }

        public static synchronized Component text() {
            return text_;
        }

        public static synchronized long deadline() {
            return deadline_;
        }

        public static synchronized void hide() {
            deadline_ = 0L;
            text_ = EMPTY_TEXT;
        }

        public static synchronized void show(Component s, int displayTimeoutMs) {
            text_ = s == null ? EMPTY_TEXT : s.m_6881_();
            deadline_ = System.currentTimeMillis() + (long)displayTimeoutMs;
        }

        public static synchronized void show(String s, int displayTimeoutMs) {
            text_ = s == null || s.isEmpty() ? EMPTY_TEXT : new TextComponent(s);
            deadline_ = System.currentTimeMillis() + (long)displayTimeoutMs;
        }

        TextOverlayGui() {
            super((Component)new TextComponent(""));
        }

        @SubscribeEvent
        public void onRenderGui(RenderGameOverlayEvent.Post event) {
            if (event.getType() != RenderGameOverlayEvent.ElementType.CHAT) {
                return;
            }
            if (TextOverlayGui.deadline() < System.currentTimeMillis()) {
                return;
            }
            if (TextOverlayGui.text() == EMPTY_TEXT) {
                return;
            }
            String txt = TextOverlayGui.text().getString();
            if (txt.isEmpty()) {
                return;
            }
            PoseStack mxs = event.getMatrixStack();
            Window win = this.mc.m_91268_();
            Font fr = this.mc.f_91062_;
            boolean was_unicode = fr.m_92718_();
            int cx = win.m_85445_() / 2;
            int cy = (int)((double)win.m_85446_() * overlay_y_);
            int w = fr.m_92895_(txt);
            Objects.requireNonNull(fr);
            int h = 9;
            this.m_93179_(mxs, cx - w / 2 - 3, cy - 2, cx + w / 2 + 2, cy + h + 2, -1439485133, -1438366652);
            this.m_93154_(mxs, cx - w / 2 - 3, cx + w / 2 + 2, cy - 2, -1439485133);
            this.m_93154_(mxs, cx - w / 2 - 3, cx + w / 2 + 2, cy + h + 2, -1439485133);
            this.m_93222_(mxs, cx - w / 2 - 3, cy - 2, cy + h + 2, -1439485133);
            this.m_93222_(mxs, cx + w / 2 + 2, cy - 2, cy + h + 2, -1439485133);
            TextOverlayGui.m_93215_((PoseStack)mxs, (Font)fr, (Component)TextOverlayGui.text(), (int)cx, (int)(cy + 1), (int)0xFFAA00);
        }
    }
}

